/*********************************************************************** 
   Copyright (c) 2013  Monty Program Ab;
   Copyright (c) 2013  Georg Richter

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   2. Redistributions in binary form must the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.

   THIS SOFTWARE IS PROVIDED BY <COPYRIGHT HOLDER> ``AS IS'' AND ANY
   EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.
************************************************************************/

#ifndef _ma_driver_h_
#define _ma_driver_h_

extern CRITICAL_SECTION globalLock;
void DriverGlobalInit();
void DriverGlobalClean(void);
void IncrementEnvCount();
void DecrementEnvCount();
MADB_List* CheckDeletedStmt(void* stmtObjAddr);
BOOL RemoveStmtFromDeleted(void* stmtObjAddr);
void RememberDeletedStmt(void* stmtObjAddr);

typedef struct {
  char *DriverName;
  char *OdbcLibrary;
  char *SetupLibrary;
} MADB_Drv;

MADB_Drv* MADB_DriverGet(char *DriverName);
void      MADB_DriverFree(MADB_Drv *Drv);
MADB_Drv* MADB_DriverInit(void);

#endif /* _ma_driver_h_ */
